function [Cal] = STM32F411_ADC_CAL(skt,CalVolts)
%function [Cal] = STM32F411_ADC_CAL(skt,CalVolts) 
%
% Set Calibration value on the STM module for later use
% skt       :   udp socket structure - see sktopen.m 
% CalVolts  :   Voltage of internal reference - default is 1.21V
% Cal       :   Scale factor to apply to left justified ADC value to get volts
% N.B. 
%Uses  aquire of channel 17 (1.21V internal reference) to calculate cal value
% Will start and stop ADC and remove any existing ADC setup
%
% To get unscaled cal - i.e. raw left justified ADC vaules use udpset(skt,"ADC1_CAL",1.0);
%
% See see sktopen.m STM32F411_ADC_SETUP.m STM32F411_ADC_PLOT.m
% Ian Stothers 14th March 2021
% To Do  - ?

if (nargin<2)
  CalVolts=1.21;
endif  
STM32F411_bitfields; % Get some bitfields
udpset(skt,"ADC1_CAL",1.0);
STM32F411_ADC_SETUP(skt,17,100000);
a=STM32F411_ADC_PLOT(skt,10000,0);
udp_bit_clear(skt,"TIM2_CR1",CEN);      % Tell TIM2 to stop

Cal=CalVolts/(mean(a));
udpset(skt,"ADC1_CAL",Cal);
end
 